<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Detalle de Compra')); ?> #<?php echo e($purchase->id); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Header Info -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                <div class="p-6 bg-white border-b border-gray-200">
                    <div class="flex justify-between items-start">
                        <div>
                            <h3 class="text-lg font-bold text-gray-900">Proveedor: <?php echo e($purchase->supplier->name); ?></h3>
                            <p class="text-sm text-gray-600">Almacén: <?php echo e($purchase->warehouse->name); ?></p>
                            <p class="text-sm text-gray-600">Fecha: <?php echo e($purchase->purchase_date->format('d/m/Y')); ?></p>
                            <p class="text-sm text-gray-600 mt-2">Registrado por:
                                <?php echo e($purchase->user->name ?? 'Sistema'); ?>

                            </p>
                        </div>
                        <div class="text-right">
                            <div class="text-2xl font-bold text-gray-900">
                                <?php echo e($globalSettings['currency_symbol'] ?? '$'); ?><?php echo e(number_format($purchase->total_amount, 2)); ?>

                            </div>
                            <div class="mt-2">
                                <?php if($purchase->status === 'pending'): ?>
                                    <span
                                        class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                        Pendiente de Recepción
                                    </span>
                                <?php elseif($purchase->status === 'received'): ?>
                                    <span
                                        class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                        Recibido
                                    </span>
                                <?php else: ?>
                                    <span
                                        class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">
                                        <?php echo e(ucfirst($purchase->status)); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <?php if($purchase->notes): ?>
                        <div class="mt-4 p-4 bg-gray-50 rounded border">
                            <h4 class="text-xs font-bold text-gray-500 uppercase">Notas</h4>
                            <p class="text-sm text-gray-700"><?php echo e($purchase->notes); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Action Bar -->
            <?php if($purchase->status === 'pending'): ?>
                <div class="flex justify-end gap-4 mb-6">
                    <form action="<?php echo e(route('purchases.destroy', $purchase)); ?>" method="POST"
                        id="deleteForm-<?php echo e($purchase->id); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" onclick="confirmDelete(<?php echo e($purchase->id); ?>)"
                            class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded shadow transition">
                            Eliminar Compra
                        </button>
                    </form>

                    <form action="<?php echo e(route('purchases.receive', $purchase)); ?>" method="POST"
                        id="receiveForm-<?php echo e($purchase->id); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="button" onclick="confirmReceive(<?php echo e($purchase->id); ?>)"
                            class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded shadow transition flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7">
                                </path>
                            </svg>
                            Recibir Mercadería e Ingresar Stock
                        </button>
                    </form>
                </div>

                <script>
                    function confirmDelete(id) {
                        Swal.fire({
                            title: '¿Eliminar Compra?',
                            text: "Esta acción no se puede deshacer.",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#d33',
                            cancelButtonColor: '#3085d6',
                            confirmButtonText: 'Sí, eliminar',
                            cancelButtonText: 'Cancelar'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                document.getElementById('deleteForm-' + id).submit();
                            }
                        })
                    }

                    function confirmReceive(id) {
                        Swal.fire({
                            title: '¿Confirmar Recepción?',
                            text: "Esto aumentará el stock en el almacén seleccionado.",
                            icon: 'question',
                            showCancelButton: true,
                            confirmButtonColor: '#10b981', // green-500
                            cancelButtonColor: '#d33',
                            confirmButtonText: 'Sí, recibir insumos',
                            cancelButtonText: 'Cancelar'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                document.getElementById('receiveForm-' + id).submit();
                            }
                        })
                    }
                </script>
            <?php endif; ?>

            <!-- Items Table -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Detalle de Insumos</h3>
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Insumo</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Cantidad
                                </th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Costo Unit.
                                </th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Total</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <?php $__currentLoopData = $purchase->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo e($item->supply->name); ?>

                                        <span class="text-gray-500 text-xs">(<?php echo e($item->supply->base_unit); ?>)</span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 text-right">
                                        <?php echo e(number_format($item->quantity, 2)); ?>

                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 text-right">
                                        <?php echo e($globalSettings['currency_symbol'] ?? '$'); ?><?php echo e(number_format($item->unit_cost, 2)); ?>

                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-900 text-right">
                                        <?php echo e($globalSettings['currency_symbol'] ?? '$'); ?><?php echo e(number_format($item->total_cost, 2)); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot class="bg-gray-50">
                            <tr>
                                <td colspan="3" class="px-6 py-4 text-right font-bold text-gray-900">Total:</td>
                                <td class="px-6 py-4 text-right font-bold text-gray-900 text-lg">
                                    <?php echo e($globalSettings['currency_symbol'] ?? '$'); ?><?php echo e(number_format($purchase->total_amount, 2)); ?>

                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <div class="mt-4">
                <a href="<?php echo e(route('purchases.index')); ?>" class="text-indigo-600 hover:text-indigo-900 font-medium">←
                    Volver al listado</a>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH C:\Webs\PHP\panaderiapasteleria\resources\views/purchases/show.blade.php ENDPATH**/ ?>