<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'variant' => 'primary', // primary, secondary, success, danger, warning
    'size' => 'md', // sm, md, lg
    'icon' => null,
    'loading' => false,
    'href' => null
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'variant' => 'primary', // primary, secondary, success, danger, warning
    'size' => 'md', // sm, md, lg
    'icon' => null,
    'loading' => false,
    'href' => null
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
$baseClasses = 'inline-flex items-center justify-center font-semibold rounded-xl transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-offset-2';

$variantClasses = [
    'primary' => 'bg-bakery-gold hover:bg-bakery-gold-dark text-white shadow-soft hover:shadow-lg hover:-translate-y-0.5 focus:ring-bakery-gold',
    'secondary' => 'bg-white hover:bg-gray-50 text-bakery-dark border-2 border-bakery-gold hover:shadow-soft focus:ring-bakery-gold',
    'success' => 'bg-bakery-green hover:bg-bakery-green-light text-white shadow-soft hover:shadow-lg focus:ring-bakery-green',
    'danger' => 'bg-bakery-red hover:bg-bakery-red-light text-white shadow-soft hover:shadow-lg focus:ring-bakery-red',
    'warning' => 'bg-yellow-500 hover:bg-yellow-600 text-white shadow-soft hover:shadow-lg focus:ring-yellow-500',
];

$sizeClasses = [
    'sm' => 'px-4 py-2 text-sm',
    'md' => 'px-6 py-2.5 text-base',
    'lg' => 'px-8 py-3 text-lg',
];

$classes = $baseClasses . ' ' . ($variantClasses[$variant] ?? $variantClasses['primary']) . ' ' . ($sizeClasses[$size] ?? $sizeClasses['md']);
?>

<?php if($href || $attributes->has('href')): ?>
    <a href="<?php echo e($href ?? $attributes->get('href')); ?>" <?php echo e($attributes->except('href')->merge(['class' => $classes])); ?>>
        <?php if($loading): ?>
            <svg class="animate-spin -ml-1 mr-2 h-4 w-4" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
            </svg>
        <?php elseif($icon): ?>
            <span class="-ml-1 mr-2">
                <?php echo $icon; ?>

            </span>
        <?php endif; ?>
        
        <?php echo e($slot); ?>

    </a>
<?php else: ?>
    <button <?php echo e($attributes->merge(['class' => $classes, 'disabled' => $loading])); ?>>
        <?php if($loading): ?>
            <svg class="animate-spin -ml-1 mr-2 h-4 w-4" fill="none" viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
            </svg>
        <?php elseif($icon): ?>
            <span class="-ml-1 mr-2">
                <?php echo $icon; ?>

            </span>
        <?php endif; ?>
        
        <?php echo e($slot); ?>

    </button>
<?php endif; ?>
<?php /**PATH C:\Webs\PHP\panaderiapasteleria\resources\views/components/action-button.blade.php ENDPATH**/ ?>