<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                <?php echo e(__('Detalle de Insumo')); ?>: <?php echo e($supply->name); ?>

            </h2>
            <a href="<?php echo e(route('supplies.index')); ?>" class="text-indigo-600 hover:text-indigo-900">
                &larr; Volver
            </a>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">

            <!-- General Info Card -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Información General</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <span class="block text-sm font-medium text-gray-500">Nombre</span>
                        <span class="block text-lg font-semibold text-gray-900"><?php echo e($supply->name); ?></span>
                    </div>
                    <div>
                        <span class="block text-sm font-medium text-gray-500">Unidad Base</span>
                        <span class="badge badge-bakery"><?php echo e(strtoupper($supply->base_unit)); ?></span>
                    </div>
                    <div>
                        <span class="block text-sm font-medium text-gray-500">Costo Actual</span>
                        <span class="block text-lg font-semibold text-gray-900"><?php echo (($globalSettings['currency_symbol'] ?? '$') . ' ' . number_format($supply->cost, 2)); ?></span>
                    </div>
                    <div>
                        <span class="block text-sm font-medium text-gray-500">Proveedor Principal</span>
                        <span class="block text-lg text-gray-900"><?php echo e($supply->supplier?->name ?? 'N/A'); ?></span>
                    </div>
                    <div>
                        <span class="block text-sm font-medium text-gray-500">Min. Stock</span>
                        <span class="block text-lg text-gray-900"><?php echo e($supply->min_stock); ?></span>
                    </div>
                    <div>
                        <span class="block text-sm font-medium text-gray-500">Estado</span>
                        <span class="badge <?php echo e($supply->status ? 'badge-success' : 'badge-danger'); ?>">
                            <?php echo e($supply->status ? 'Activo' : 'Inactivo'); ?>

                        </span>
                    </div>
                </div>
            </div>

            <!-- Stock by Warehouse -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Stock por Almacén</h3>
                <div class="overflow-x-auto">
                    <table class="table-modern w-full">
                        <thead>
                            <tr>
                                <th>Almacén</th>
                                <th class="text-right">Cantidad</th>
                                <th class="text-right">Valorizado</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $supply->stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($stock->warehouse->name); ?></td>
                                    <td class="text-right font-bold"><?php echo e(number_format($stock->quantity, 2)); ?>

                                        <?php echo e($supply->base_unit); ?></td>
                                    <td class="text-right"><?php echo (($globalSettings['currency_symbol'] ?? '$') . ' ' . number_format($stock->quantity * $supply->cost, 2)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center text-gray-500 py-4">No hay stock registrado en
                                        almacenes.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                        <tfoot>
                            <tr class="bg-gray-50 font-bold">
                                <td>TOTAL</td>
                                <td class="text-right"><?php echo e(number_format($supply->stocks->sum('quantity'), 2)); ?></td>
                                <td class="text-right"><?php echo (($globalSettings['currency_symbol'] ?? '$') . ' ' . number_format($supply->stocks->sum('quantity') * $supply->cost, 2)); ?></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <!-- Movement History -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Historial de Movimientos</h3>
                <div class="overflow-x-auto">
                    <table class="table-modern w-full text-sm">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Tipo</th>
                                <th>Descripción</th>
                                <th>Usuario</th>
                                <th class="text-right">Cantidad</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $movements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($movement->created_at->format('d/m/Y H:i')); ?></td>
                                    <td>
                                        <?php if(in_array($movement->type, ['purchase', 'return', 'correction_in'])): ?>
                                            <span class="text-green-600 font-bold">Entrada</span>
                                        <?php else: ?>
                                            <span class="text-red-600 font-bold">Salida</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="block text-gray-900"><?php echo e($movement->type); ?></span>
                                        <span class="text-xs text-gray-500"><?php echo e($movement->description); ?></span>
                                    </td>
                                    <td><?php echo e($movement->user->name ?? 'Sistema'); ?></td>
                                    <td
                                        class="text-right font-bold <?php echo e($movement->quantity > 0 ? 'text-green-600' : 'text-red-600'); ?>">
                                        <?php echo e($movement->quantity > 0 ? '+' : ''); ?><?php echo e(number_format($movement->quantity, 2)); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-gray-500 py-4">No hay movimientos registrados.
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    <div class="mt-4">
                        <?php echo e($movements->links()); ?>

                    </div>
                </div>
            </div>

        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH C:\Webs\PHP\panaderiapasteleria\resources\views/supplies/show.blade.php ENDPATH**/ ?>