<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Nuevo Ajuste de Inventario')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <!-- TomSelect CSS -->
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.2.2/dist/css/tom-select.css" rel="stylesheet">
    <style>
        .ts-control {
            border-radius: 0.375rem;
            border-color: #d1d5db;
            padding: 0.5rem 0.75rem;
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
        }

        .ts-control.focus {
            border-color: #d97706;
            box-shadow: 0 0 0 3px rgba(217, 119, 6, 0.5);
        }
    </style>

    <div class="py-12">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">

                    <form action="<?php echo e(route('inventory.adjustments.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <!-- Top Selector: Type -->
                        <div class="mb-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Tipo de Ajuste</label>
                                <select name="adjustment_type"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-bakery-gold focus:ring focus:ring-bakery-gold focus:ring-opacity-50"
                                    required>
                                    <option value="waste" class="text-red-600">Merma / Desperdicio (-)</option>
                                    <option value="return" class="text-green-600">Devolución (+)</option>
                                    <option value="correction_in" class="text-blue-600">Corrección / Ingreso Manual (+)
                                    </option>
                                    <option value="correction_out" class="text-orange-600">Corrección / Salida Manual
                                        (-)</option>
                                </select>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Tipo de Item</label>
                                <div class="flex space-x-4 mt-2">
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="item_type" value="supply" checked
                                            class="text-bakery-gold focus:ring-bakery-gold" onchange="toggleItemType()">
                                        <span class="ml-2">Insumo</span>
                                    </label>
                                    <label class="inline-flex items-center">
                                        <input type="radio" name="item_type" value="product"
                                            class="text-bakery-gold focus:ring-bakery-gold" onchange="toggleItemType()">
                                        <span class="ml-2">Producto</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Supply Section -->
                        <div id="supply-section"
                            class="mb-6 border-l-4 border-bakery-gold pl-4 bg-yellow-50 p-4 rounded-r">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Seleccionar
                                        Insumo</label>
                                    <select id="supply-select" name="item_id_supply" class="tom-select w-full"
                                        placeholder="Buscar insumo...">
                                        <option value="">Seleccione...</option>
                                        <?php $__currentLoopData = $supplies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($supply->id); ?>"><?php echo e($supply->name); ?> (<?php echo e($supply->base_unit); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Almacén Afectado</label>
                                    <select name="warehouse_id"
                                        class="block w-full rounded-md border-gray-300 shadow-sm focus:border-bakery-gold focus:ring focus:ring-bakery-gold focus:ring-opacity-50">
                                        <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($warehouse->id); ?>"><?php echo e($warehouse->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Product Section (Hidden by default) -->
                        <div id="product-section"
                            class="mb-6 border-l-4 border-bakery-dark pl-4 bg-gray-50 p-4 rounded-r hidden">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="col-span-2">
                                    <label class="block text-sm font-medium text-gray-700 mb-1">Seleccionar
                                        Producto</label>
                                    <select id="product-select" name="item_id_product" class="tom-select w-full"
                                        placeholder="Buscar producto...">
                                        <option value="">Seleccione...</option>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($product->id); ?>"><?php echo e($product->full_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Quantity & Reason -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Cantidad</label>
                                <input type="number" name="quantity" step="0.01" min="0.01"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-bakery-gold focus:ring focus:ring-bakery-gold focus:ring-opacity-50"
                                    required placeholder="0.00">
                                <p class="text-xs text-gray-500 mt-1">Ingrese siempre en positivo. El sistema calculará
                                    la entrada/salida según el Tipo de Ajuste.</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Motivo / Observación</label>
                                <input type="text" name="reason"
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-bakery-gold focus:ring focus:ring-bakery-gold focus:ring-opacity-50"
                                    placeholder="Ej: Vencimiento, Rotura, Error de conteo">
                            </div>
                        </div>

                        <!-- Hidden Field for consolidated Item ID -->
                        <!-- Hidden Field for consolidated Item ID - Removed -->

                        <div class="flex justify-end pt-4">
                            <button type="submit"
                                class="bg-bakery-dark hover:bg-gray-800 text-white font-bold py-2 px-6 rounded shadow transition">
                                Guardar Ajuste
                            </button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://cdn.jsdelivr.net/npm/tom-select@2.2.2/dist/js/tom-select.complete.min.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                // Init TomSelects
                const supplySelect = new TomSelect('#supply-select', {
                    create: false,
                    sortField: { field: "text", direction: "asc" },
                    plugins: ['dropdown_input'],
                });
                const productSelect = new TomSelect('#product-select', {
                    create: false,
                    sortField: { field: "text", direction: "asc" },
                    plugins: ['dropdown_input'],
                });

                window.toggleItemType = function () {
                    const type = document.querySelector('input[name="item_type"]:checked').value;
                    const supplySec = document.getElementById('supply-section');
                    const productSec = document.getElementById('product-section');

                    if (type === 'supply') {
                        supplySec.classList.remove('hidden');
                        productSec.classList.add('hidden');
                        supplySelect.clear(); // Reset to ensure user picks
                    } else {
                        supplySec.classList.add('hidden');
                        productSec.classList.remove('hidden');
                        productSelect.clear();
                    }
                }

                // Sync ID before submit
                document.querySelector('form').addEventListener('submit', function (e) {
                    const type = document.querySelector('input[name="item_type"]:checked').value;
                    const finalIdInput = document.getElementById('final-item-id');

                    if (type === 'supply') {
                        finalIdInput.value = document.getElementById('supply-select').value;
                    } else {
                        finalIdInput.value = document.getElementById('product-select').value;
                    }

                    if (!finalIdInput.value) {
                        e.preventDefault();
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Debe seleccionar un item (Insumo o Producto).'
                        });
                    }
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH C:\Webs\PHP\panaderiapasteleria\resources\views/inventory/adjustments/create.blade.php ENDPATH**/ ?>